﻿' 版权所有 (C) Microsoft Corporation。保留所有权利。
Imports System.Text.RegularExpressions

Public Class RegExTextBox
    Inherits System.Windows.Forms.TextBox

    '用于验证 TextBox 中的文本的 RegEx
    '的字符串表示形式。需要它的原因是
    '该属性需要以字符串的形式公开以便
    '在设计时设置。
    Protected validationPattern As String

    '应在文本与模式不匹配时
    '使用的消息。
    Protected mErrorMessage As String

    '用于执行验证的 RegEx 对象。
    Protected mValidationExpression As Regex

    'TextBox 中的文本无效时使用的
    '默认颜色。
    Protected mErrorColor As Color = Color.Red

    '允许开发人员设置设计时或运行时的
    '的错误信息。
    Public Property ErrorMessage() As String
        Get
            Return mErrorMessage
        End Get
        Set(ByVal Value As String)
            mErrorMessage = Value
        End Set
    End Property

    '如果 TextBox 文本与 RegEx 不匹配，则
    '该文本将更改为此颜色。
    Public Property ErrorColor() As Color
        Get
            Return mErrorColor
        End Get
        Set(ByVal Value As Color)
            mErrorColor = Value
        End Set
    End Property

    '让开发人员确定 TextBox 中的文本
    '是否有效。
    Public ReadOnly Property IsValid() As Boolean
        Get
            If Not mValidationExpression Is Nothing Then
                Return mValidationExpression.IsMatch(Me.Text)
            Else
                Return True
            End If
        End Get
    End Property

    '让开发人员指定正则表达式
    '（以字符串的形式），以用于验证
    ' TextBox 中的文本。该表达式可采用字符串
    '（与 RegEx 对象比较）的形式来设置很重要，这样，开发人员就可以
    '使用属性窗口指定 RegEx 模式。
    Public Property ValidationExpression() As String
        Get
            Return validationPattern
        End Get
        Set(ByVal Value As String)
            mValidationExpression = New Regex(Value)
            validationPattern = Value
        End Set
    End Property

    '如果文本与 RegEx 不匹配，则将
    '文本的颜色更改为 ErrorColor。如果匹配，
    '则确保其使用默认颜色显示。
    Protected Overrides Sub OnValidated(ByVal e As System.EventArgs)
        If Not Me.IsValid Then
            Me.ForeColor = mErrorColor
        Else
            Me.ForeColor = DefaultForeColor
        End If

        '任何时候继承控件并重写其中一个
        'On... sub 时，调用基类的 On...
        '方法都至关重要，否则控件将不会
        '像预期那样激发事件。
        MyBase.OnValidated(e)
    End Sub

End Class
